// routes/collegeRoutes.js
const express = require("express");
const router = express.Router();
const collegeController = require("../../controllers/college/collegeController");
const comparisonController = require("../../controllers/collegeComparisonController");
const upload = require("../../config/multer");

router.post("/", upload, collegeController.createCollege);
router.get("/", collegeController.getCollege);
router.get(
  "/compare/:college1Id/:college2Id",
  comparisonController.compareColleges
);
router.delete("/:id", collegeController.deleteCollege);
// Add this to your collegeRoutes.js
router.get("/details/:id", collegeController.getCollegeDetails);
router.get("/details", collegeController.getMultipleCollegeDetails);

module.exports = router;
