const express = require("express");
const router = express.Router();
const ppStoryController = require("../../controllers/blog/ppStoryController");

// Story routes
router.post("/", ppStoryController.createStory);
router.get("/", ppStoryController.getAllStories);
router.get("/images/:filename", ppStoryController.getStoryImage);
router.get("/:id", ppStoryController.getStoryWithData);
router.post("/:id/data", ppStoryController.addStoryData);
router.put("/:id", ppStoryController.updateStory);
router.delete("/:id", ppStoryController.deleteStory);

// Category routes
router.get("/categories", ppStoryController.getAllCategories);
router.get("/categories/:id", ppStoryController.getCategoryById);
router.post("/categories", ppStoryController.createCategory);
router.put("/categories/:id", ppStoryController.updateCategory);
router.delete("/categories/:id", ppStoryController.deleteCategory);

module.exports = router;
