module.exports = (sequelize, DataTypes) => {
  const StudyGoal = sequelize.define(
    "StudyGoal",
    {
      title: {
        type: DataTypes.STRING,
        allowNull: false,
        validate: {
          notEmpty: true,
        },
      },
      collegeCount: {
        type: DataTypes.INTEGER,
        field: "college_count",
        defaultValue: 0,
      },
      slug: {
        type: DataTypes.STRING,
        unique: true,
        allowNull: false,
      },
      icon: {
        type: DataTypes.STRING, // Stores icon path or class
      },
      isActive: {
        type: DataTypes.BOOLEAN,
        field: "is_active",
        defaultValue: true,
      },
      displayOrder: {
        type: DataTypes.INTEGER,
        field: "display_order",
        defaultValue: 0,
      },
    },
    {
      tableName: "study_goals",
      timestamps: true,
      underscored: true,
    }
  );

  StudyGoal.associate = (models) => {
    StudyGoal.hasMany(models.StudyGoalProgram, {
      foreignKey: "study_goal_id",
      as: "studyGoalPrograms",
    });
  };

  return StudyGoal;
};
