// models/GroupAPI/imageModel.js
module.exports = (sequelize, DataTypes) => {
  const CollegeImage = sequelize.define(
    "CollegeImage", // Changed to proper model name
    {
      image_id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
      },
      fk_college_id: {
        type: DataTypes.INTEGER,
        references: {
          model: "tbl_college", // Reference actual table name
          key: "college_id",
        },
      },
      image_url: DataTypes.STRING(500),
      is_cover: DataTypes.TINYINT,
      is_logo: DataTypes.TINYINT,
    },
    {
      tableName: "tbl_college_images", // Keep actual table name here
      timestamps: false,
    }
  );

  CollegeImage.associate = (models) => {
    CollegeImage.belongsTo(models.College, {
      foreignKey: "fk_college_id",
      as: "college",
    });
  };

  return CollegeImage;
};
