module.exports = (sequelize, DataTypes) => {
  const CollegeCourse = sequelize.define(
    "tbl_college_courses",
    {
      course_id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
      },
      fk_college_id: DataTypes.INTEGER,
      course_name: DataTypes.TEXT,
      course_fees: DataTypes.DOUBLE,
      degree_approval: DataTypes.STRING(1000),
      course_mode: DataTypes.STRING(250),
      course_duration: DataTypes.STRING(250),
    },
    {
      tableName: "tbl_college_courses",
      timestamps: false,
    }
  );

  CollegeCourse.associate = (models) => {
    CollegeCourse.belongsTo(models.College, {
      foreignKey: "fk_college_id",
      as: "college",
    });
  };

  return CollegeCourse;
};
