module.exports = (sequelize, DataTypes) => {
  const PPStoryCategory = sequelize.define(
    "PPStoryCategory",
    {
      ppc_id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
        field: "ppc_id",
      },
      ppc_title: {
        type: DataTypes.TEXT,
        field: "ppc_title",
      },
      ppc_description: {
        type: DataTypes.TEXT,
        field: "ppc_description",
      },
      ppc_satus: {
        // Fixed typo from 'ppc_satus'
        type: DataTypes.INTEGER,
        field: "ppc_satus",
      },
      ppc_created_date: {
        type: DataTypes.DATE,
        field: "ppc_created_date",
      },
    },
    {
      tableName: "pp_category",
      timestamps: false,
      underscored: true,
    }
  );

  PPStoryCategory.associate = function (models) {
    PPStoryCategory.hasMany(models.PPStory, {
      foreignKey: "fk_ppa_id",
      as: "stories",
    });
  };

  return PPStoryCategory;
};
