module.exports = (sequelize, DataTypes) => {
  const blogComments = sequelize.define(
    "blogComments",
    {
      full_name: {
        type: DataTypes.STRING(255),
        allowNull: true,
      },
      mobile: {
        type: DataTypes.STRING(12),
        allowNull: true,
      },
      blog_id: {
        type: DataTypes.INTEGER,
        allowNull: false,
      },
      email: {
        type: DataTypes.STRING(255),
        allowNull: true,
      },
      message: {
        type: DataTypes.TEXT,
        allowNull: true,
      },
      status: {
        type: DataTypes.INTEGER,
        defaultValue: 1,
      },
      date: {
        type: DataTypes.DATE,
        defaultValue: DataTypes.NOW,
      },
    },
    {
      tableName: "tpl_blog_comment",
      timestamps: false,
      underscored: true,
    }
  );

  return blogComments;
};
