const { Sequelize, DataTypes } = require("sequelize");

const sequelize = new Sequelize("gogyani_bmcdb", "gogyani_bmcuser", "CXuY##G8Abe!", {
  host: "198.38.87.121",
  dialect: "mysql",
  logging: false,
  port:3306,
  pool: {
    max: 5,
    min: 0,
    acquire: 30000,
    idle: 10000,
  },
});

const db = {
  sequelize,
  Sequelize,
};

// Initialize all models in proper order (independent models first)
db.User = require("./models/AuthModel/userModel")(sequelize, DataTypes);
db.College = require("./models/collegeModel/collegeModel")(
  sequelize,
  DataTypes
);

// Other models
db.LandingPage = require("./models/LandingPageModel/landingPageModel")(
  sequelize,
  DataTypes
);
db.Company = require("./models/collegeModel/CompanyModel")(
  sequelize,
  DataTypes
);
db.ImportantDate = require("./models/collegeModel/importantdateModel")(
  sequelize,
  DataTypes
);
db.Blog = require("./models/Blog/blogModel")(sequelize, DataTypes);
db.BlogTag = require("./models/Blog/blogTagModel")(sequelize, DataTypes);
db.BlogComments = require("./models/Blog/blogCommentsModel")(
  sequelize,
  DataTypes
);
db.BlogCategory = require("./models/Blog/blogCategoryModel")(
  sequelize,
  DataTypes
);
db.StudentUG = require("./models/Students/studentUG.model")(
  sequelize,
  DataTypes
);
db.StudentMBA = require("./models/Students/studentMBA.model")(
  sequelize,
  DataTypes
);
db.Student = require("./models/Students/studentModel")(sequelize, DataTypes);
db.Banner = require("./models/BannerModel")(sequelize, DataTypes);
db.StudyGoal = require("./models/StudyGoal/studyGoalModel")(
  sequelize,
  DataTypes
);
db.StudyGoalProgram = require("./models/StudyGoal/studyGoalProgramModel")(
  sequelize,
  DataTypes
);
db.Exam = require("./models/ExamModel/examModel")(sequelize, DataTypes);
db.CollegeComparison = require("./models/CollegeComparison")(
  sequelize,
  DataTypes
);
db.Course = require("./models/ExploreCourse/course.model")(
  sequelize,
  DataTypes
);
db.Notification = require("./models/notificationModel")(sequelize, DataTypes);
db.MainCollege = require("./models/GroupAPI/collegeModel")(
  sequelize,
  DataTypes
);
db.CollegeCourse = require("./models/CollegeCourse")(sequelize, DataTypes);
db.CollegeImage = require("./models/GroupAPI/imageModel")(sequelize, DataTypes);
db.CollegeReview = require("./models/GroupAPI/reviewModel")(
  sequelize,
  DataTypes
);
db.CollegeVideo = require("./models/GroupAPI/videoModel")(sequelize, DataTypes);

db.PPStory = require("./models/Blog/ppStoryModel")(sequelize, DataTypes);
db.PPStoryData = require("./models/Blog/ppStoryDataModel")(
  sequelize,
  DataTypes
);
db.PPStoryCategory = require("./models/Blog/ppCategory")(sequelize, DataTypes);

// Set up associations after all models are loaded
Object.keys(db).forEach((modelName) => {
  if (db[modelName].associate) {
    db[modelName].associate(db);
  }
});

// Test connection
(async () => {
  try {
    await sequelize.authenticate();
    console.log("Database connection has been established successfully.");
  } catch (error) {
    console.error("Unable to connect to the database:", error);
  }
})();

module.exports = db;
